document.addEventListener('DOMContentLoaded', () => {

    // --- Gallery Lightbox Logic ---
    const lightboxModal = document.getElementById('lightboxModal');
    if (lightboxModal) {
        lightboxModal.addEventListener('show.bs.modal', function (event) {
            // Button that triggered the modal
            const button = event.relatedTarget;
            // Extract info from data-bs-* attributes
            const imageUrl = button.getAttribute('data-bs-image');
            // Update the modal's content.
            const modalImage = lightboxModal.querySelector('#lightboxImage');
            modalImage.src = imageUrl;
        });
    }

    // --- Contact Form to WhatsApp Logic ---
    const contactForm = document.getElementById('contactForm');
    if (contactForm) {
        contactForm.addEventListener('submit', function (e) {
            e.preventDefault();

            const name = document.getElementById('name').value;
            const phone = document.getElementById('phone').value;
            const message = document.getElementById('message').value;

            // WhatsApp Number (Replace with actual temple number if different)
            const waNumber = "919847577755";

            const text = `*New Enquiry from Website*%0A%0A*Name:* ${name}%0A*Phone:* ${phone}%0A*Message:* ${message}`;

            const waUrl = `https://wa.me/${waNumber}?text=${text}`;

            window.open(waUrl, '_blank');
        });
    }

    // --- Active Nav Link Highlighter ---
    const currentPath = window.location.pathname;
    const navItems = document.querySelectorAll('.nav-link');

    navItems.forEach(item => {
        if (item.getAttribute('href') === currentPath || (currentPath === '/' && item.getAttribute('href') === 'index.html')) {
            item.classList.add('active');
        }
    });

});
